{********************************************
; File: Events.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT EVENTS;
INTERFACE
USES TYPES,MISCTOOL;
CONST

{ Error Codes }
emDupStrtUpErr = $0601;  { duplicate EMStartup Call }
emResetErr = $0602;  { can't reset error the Event Manager }
emNotActErr = $0603;  { event manager not active }
emBadEvtCodeErr = $0604;  { illegal event code }
emBadBttnNoErr = $0605;  { illegal button number }
emQSiz2LrgErr = $0606;  { queue size too large }
emNoMemQueueErr = $0607;  { not enough memory for queue }
emBadEvtQErr = $0681;  { fatal sys error - event queue damaged }
emBadQHndlErr = $0682;  { fatal sys error - queue handle damaged }

{ Event Codes }
nullEvt = $0000;
mouseDownEvt = $0001;
mouseUpEvt = $0002;
keyDownEvt = $0003;
autoKeyEvt = $0005;
updateEvt = $0006;
activateEvt = $0008;
switchEvt = $0009;
deskAccEvt = $000A;
driverEvt = $000B;
app1Evt = $000C;
app2Evt = $000D;
app3Evt = $000E;
app4Evt = $000F;

{ Event Masks }
mDownMask = $0002;
mUpMask = $0004;
keyDownMask = $0008;
autoKeyMask = $0020;
updateMask = $0040;
activeMask = $0100;
switchMask = $0200;
deskAccMask = $0400;
driverMask = $0800;
app1Mask = $1000;
app2Mask = $2000;
app3Mask = $4000;
app4Mask = $8000;
everyEvent = $FFFF;

{ Journal Codes }
jcTickCount = $00;  { TickCount call }
jcGetMouse = $01;  { GetMouse call }
jcButton = $02;  { Button call }
jcEvent = $04;  { GetNextEvent and EventAvail calls }

{ Modifiers Flags }
activeFlag = $0001;  { set if window being activated }
changeFlag = $0002;  { set if active wind. changed state }
btn1State = $0040;  { set if button 1 up }
btn0State = $0080;  { set if button 0 up }
appleKey = $0100;  { set if Apple key down }
shiftKey = $0200;  { set if shift key down }
capsLock = $0400;  { set if caps lock key down }
optionKey = $0800;  { set if option key down }
controlKey = $1000;  { set if Control key down }
keyPad = $2000;  { set if keypress from key pad }

{ kTransID }
keyboardTransIIGS = $0000;  { use old-style Apple IIGS mapping }
keyboardTransMac = $00FF;  { use Macintosh mapping }

TYPE
EventRecordHndl = ^EventRecordPtr;
EventRecordPtr = ^EventRecord;
EventRecord = RECORD CASE INTEGER OF
    0: (
        what : Integer; { event code }
        message : Longint; { event message }
        when : Longint; { ticks since startup }
        where : Point; { mouse location }
        modifiers : Integer; { modifier flags }
       );
    1:  (
         wmWhat : Integer;
         wmMessage : Longint;
         wmWhen : Longint;
         wmWhere : Point;
         wmModifiers : Integer;
         wmTaskData : Longint; { TaskMaster return value. }
         wmTaskMask : Longint; { TaskMaster feature mask. }
         wmLastClickTick : Longint;
         wmClickCount : Integer;
         wmTaskData2 : Longint;
         wmTaskData3 : Longint;
         wmTaskData4 : Longint;
         wmLastClickPt : Point;
       );
END;
EventJournalRecHndl = ^EventJournalRecPtr;
EventJournalRecPtr = ^EventJournalRec;
EventJournalRec = RECORD
    statusMode : Integer;
    yLocation : Integer;
    xLocation : Integer;
END;
FUNCTION Button ( buttonNum:Integer) : Boolean ;
FUNCTION DoWindows  : Integer ;
PROCEDURE EMBootInit   ;
PROCEDURE EMReset   ;
PROCEDURE EMShutDown   ;
PROCEDURE EMStartUp ( dPageAddr:Integer; queueSize:Integer; xMinClamp:Integer; xMaxClamp:Integer; yMinClamp:Integer; yMaxClamp:Integer; userID:Integer)  ;
FUNCTION EMStatus  : Boolean ;
FUNCTION EMVersion  : Integer ;
FUNCTION EventAvail ( eventMask:Integer;VAR eventPtr:EventRecord) : Boolean ;
PROCEDURE FakeMouse ( changedFlag:Integer; modLatch:Integer; xPos:Integer; yPos:Integer; ButtonStatus:Integer)  ;
FUNCTION FlushEvents ( eventMask:Integer; stopMask:Integer) : Integer ;
FUNCTION GetCaretTime  : Longint ;
FUNCTION GetDblTime  : Longint ;
FUNCTION GetKeyTranslation  : Integer ;
PROCEDURE GetMouse (VAR mouseLocPtr:Point)  ;
FUNCTION GetNextEvent ( eventMask:Integer;VAR eventPtr:EventRecord) : Boolean ;
FUNCTION GetOSEvent ( eventMask:Integer;VAR eventPtr:EventRecord) : Boolean ;
FUNCTION OSEventAvail ( eventMask:Integer;VAR eventPtr:EventRecord) : Boolean ;
FUNCTION PostEvent ( eventCode:Integer; eventMsg:Longint) : Integer ;
PROCEDURE SetAutoKeyLimit ( newLimit:Integer)  ;
PROCEDURE SetEventMask ( sysEventMask:Integer)  ;
PROCEDURE SetKeyTranslation ( kTransID:Integer)  ;
PROCEDURE SetSwitch   ;
FUNCTION StillDown ( buttonNum:Integer) : Boolean ;
FUNCTION TickCount  : Longint ;
FUNCTION WaitMouseUp ( buttonNum:Integer) : Boolean ;
IMPLEMENTATION
END.
